typedef struct {
	unsigned long ChannelFrequency;//
	unsigned long ulLNBLOFLowBand;
	unsigned long ulLNBLOFHighBand;
	unsigned long SymbolRate;
	unsigned char Polarity;

	UCHAR           LNB_POWER;              // LNB_POWER_ON | LNB_POWER_OFF
    UCHAR           HZ_22K;                 // HZ_22K_OFF | HZ_22K_ON
    UCHAR           Tone_Data_Burst;        // Data_Burst_ON | Tone_Burst_ON |Tone_Data_Disable
    UCHAR           DiSEqC_Port;            // DiSEqC_NULL | DiSEqC_A | DiSEqC_B | DiSEqC_C | DiSEqC_D

	unsigned char motor[5];

	unsigned char ir_code;
	unsigned char lock;
	unsigned char strength;
	unsigned char quality;
       unsigned char FecType;
	unsigned char ModuType;
	unsigned char reserved[254];
	
} QBOXDVBSCMD, *PQBOXDVBSCMD;

#define STATIC_KSPROPERTYSET_QBOXControl \
    0xbdb891da, 0x1e7a, 0x46c4, 0x82, 0x46, 0x7a, 0xbd, 0xe3, 0x6d, 0xdb, 0x57
DEFINE_GUIDSTRUCT( "C6EFE5EB-855A-4f1b-B7AA-87B5E1DC4113", KSPROPERTYSET_QBOXControl );
#define KSPROPERTYSET_QBOXControl DEFINE_GUIDNAMED( KSPROPERTYSET_QBOXControl )

typedef enum
{
  KSPROPERTY_CTRL_TUNER,
	KSPROPERTY_CTRL_IR,
	KSPROPERTY_CTRL_22K_TONE,
	KSPROPERTY_CTRL_MOTOR,
	KSPROPERTY_CTRL_LNBPW,
	KSPROPERTY_CTRL_LOCK_TUNER,
	KSPROPERTY_CTRL_MAC,
	KSPROPERTY_CTRL_DEVICEID,
} KSPROPERTY_UTICA;

//IR code
typedef struct	{
	int dd_rmt_code;
	int	code;
} RemoteKeysBig_1; 
RemoteKeysBig_1 RemoteKeysBig[32]={	
	{RMT_LEFT,0x90},
	{RMT_UP,0x81},	
	{RMT_DOWN,0x88},
	{RMT_RIGHT,0x82},
	{RMT_MENU,0x9e},
	{RMT_MUTE,0x94},
	{RMT_RIGHT,0x93},
	{RMT_LEFT,0x8c},
	{RMT_EPG,0x97},
	{RMT_FULLSCREEN,0x9d},
	{RMT_RECORD,0x83},
	{RMT_POWER,0x84},
	{RMT_RECALL,0x80},		
	{RMT_SNAPSHOT,0x9a},
	{RMT_EXIT,0x9f},
	{RMT_PAUSE,0x98},	
	{RMT_DOWN,0x96},
	{RMT_UP,0x91},
	{RMT_OK,0x99},
	{RMT_TAB,0x95},	
	{RMT_INFO,0x9c},
	{RMT_PLAY,0x9B},
	{RMT_0,0x92},
	{RMT_1,0x87},
	{RMT_2,0x86},
	{RMT_3,0x85},
	{RMT_4,0x8b},
	{RMT_5,0x8a},
	{RMT_6,0x89},
	{RMT_7,0x8f},
	{RMT_8,0x8e},
	{RMT_9,0x8d}
};


char* CreateDVBTuneRequest(IDVBTuneRequest**   pTuneRequest2,QBOXDVBSCMD *p_CmdData);
void OnLockTransponder();
bool SendDiseqCommand(BYTE *cmd,int cmdlen);