typedef enum
{
    KSPROPERTY_DISABLE_USERMODE_I2C = 0,
    KSPROPERTY_ENABLE_USERMODE_I2C  = 1
}KSPROPERTY_I2C_STATES;

typedef struct _I2C_ACCESS
{
    KSPROPERTY_I2C_STATES state;    
}I2C_ACCESS, *PI2C_ACCESS;

typedef struct _I2C_STRUCT
{
    BYTE i2c_interface_select;
    BYTE chip_address;
    BYTE num_bytes;
    BYTE bytes[MAX_I2C_BYTES];
}I2C_STRUCT, *PI2C_STRUCT;

typedef struct _I2C_WRITE_THEN_READ_STRUCT
{
    BYTE i2c_interface_select;
    BYTE chip_address;
    BYTE num_write_bytes;
    BYTE write_bytes[MAX_SUBADDRESS_BYTES];
    BYTE num_read_bytes;
    BYTE read_bytes[MAX_I2C_BYTES];
}I2C_WRITE_THEN_READ_STRUCT, *PI2C_WRITE_THEN_READ_STRUCT;

IBaseFilter* LoadFilter(CLSID clsid)
{
	IBaseFilter *filter;

	CoCreateInstance(clsid,NULL,CLSCTX_INPROC_SERVER,IID_IBaseFilter,reinterpret_cast<void**>(&filter));
	return filter;
}

// Finds a filter based on the name
IBaseFilter* FindFilter(CLSID clsid,WCHAR *name)
{
	HRESULT hr;
    CComPtr <IMoniker>      pIMoniker;
    CComPtr <IEnumMoniker>  pIEnumMoniker;
	CComPtr <ICreateDevEnum> m_pICreateDevEnum;
	int nl;

	if(name!=NULL) nl=wcslen(name);
    if(!m_pICreateDevEnum) {
        hr=m_pICreateDevEnum.CoCreateInstance(CLSID_SystemDeviceEnum);
        if(FAILED(hr)) return NULL;
    }
    hr=m_pICreateDevEnum->CreateClassEnumerator(clsid,&pIEnumMoniker,0);
    if(FAILED(hr)||(S_OK!=hr)) return NULL;
    while(pIEnumMoniker->Next(1,&pIMoniker,0)==S_OK) {
        CComPtr <IPropertyBag>  pBag;
        hr=pIMoniker->BindToStorage(NULL,NULL,IID_IPropertyBag,reinterpret_cast<void**>(&pBag));
        if(FAILED(hr)) {
            OutputDebugString("FindFilter(): Cannot BindToStorage");
            return NULL;
        }
        CComVariant varBSTR;
        hr=pBag->Read(L"FriendlyName",&varBSTR,NULL);
        if(FAILED(hr)) {
            OutputDebugString("FindFilter(): IPropertyBag->Read method failed");
            pIMoniker=NULL;
            continue;
        }
        // bind the filter
        IBaseFilter*   pFilter;
        hr=pIMoniker->BindToObject(NULL,NULL,IID_IBaseFilter,reinterpret_cast<void**>(&pFilter));
        if(FAILED(hr)) {
            pIMoniker=NULL;
            pFilter=NULL;
            continue;
        }
		if((name==NULL)||(memcmp(varBSTR.bstrVal,name,nl)==0)) return pFilter;
        pIMoniker=NULL;
        pFilter=NULL;
    }
    return NULL;
}

IBaseFilter* CreateTunerDevice(void)
{
	return FindFilter(KSCATEGORY_BDA_NETWORK_TUNER,TunerName);
}
IBaseFilter* CreateCaptureDevice(void)
{
	return FindFilter(KSCATEGORY_BDA_RECEIVER_COMPONENT,CaptuerName);
}


IBaseFilter* CreateMPEG2Demultiplexer(void)
{
	return LoadFilter(CLSID_MPEG2Demultiplexer);
}

// this is defined in bda tuner/demod driver source (splmedia.h)
const GUID KSPROPSETID_BdaTunerExtensionProperties =
{0xfaa8f3e5, 0x31d4, 0x4e41, {0x88, 0xef, 0xd9, 0xeb, 0x71, 0x6f, 0x6e, 0xc9}};
// this is defined in bda tuner/demod driver source (splmedia.h)
typedef enum {
    KSPROPERTY_BDA_DISEQC_MESSAGE = 0,  //Custom property for Diseqc messaging
    KSPROPERTY_BDA_DISEQC_INIT,         //Custom property for Intializing Diseqc.
    KSPROPERTY_BDA_SCAN_FREQ,           //Not supported 
    KSPROPERTY_BDA_CHANNEL_CHANGE,      //Custom property for changing channel
    KSPROPERTY_BDA_DEMOD_INFO,          //Custom property for returning demod FW state and version
    KSPROPERTY_BDA_EFFECTIVE_FREQ,      //Not supported 
    KSPROPERTY_BDA_SIGNAL_STATUS,       //Custom property for returning signal quality, strength, BER and other attributes
    KSPROPERTY_BDA_LOCK_STATUS,         //Custom property for returning demod lock indicators 
    KSPROPERTY_BDA_ERROR_CONTROL,       //Custom property for controlling error correction and BER window
    KSPROPERTY_BDA_CHANNEL_INFO,        //Custom property for exposing the locked values of frequency,symbol rate etc after
                                        //corrections and adjustments
    KSPROPERTY_BDA_NBC_PARAMS

} KSPROPERTY_BDA_TUNER_EXTENSION;

////
#define STATIC_KSPROPERTYSET_QBOXControl \
    0xbdb891da, 0x1e7a, 0x46c4, 0x82, 0x46, 0x7a, 0xbd, 0xe3, 0x6d, 0xdb, 0x57
DEFINE_GUIDSTRUCT( "C6EFE5EB-855A-4f1b-B7AA-87B5E1DC4113", KSPROPERTYSET_QBOXControl );
#define KSPROPERTYSET_QBOXControl DEFINE_GUIDNAMED( KSPROPERTYSET_QBOXControl )

typedef enum
{
    KSPROPERTY_CTRL_TUNER,
	KSPROPERTY_CTRL_IR,
	KSPROPERTY_CTRL_22K_TONE,
	KSPROPERTY_CTRL_MOTOR,
	KSPROPERTY_CTRL_LNBPW,
	KSPROPERTY_CTRL_LOCK_TUNER,
	KSPROPERTY_CTRL_MAC,
	KSPROPERTY_CTRL_DEVICEID,
} KSPROPERTY_UTICA;
////////
DEFINE_GUIDSTRUCT( "CBBF16AE-2A99-477e-B0D7-9C2274EB209E", PROPSETID_CX_GOSHAWK2_DIAG_PROP);
#define  PROPSETID_CX_GOSHAWK2_DIAG_PROP  DEFINE_GUIDNAMED( PROPSETID_CX_GOSHAWK2_DIAG_PROP )

typedef enum {
    CX_GOSHAWK2_DIAG_PROP_I2C_ACCESS             = 0,
    CX_GOSHAWK2_DIAG_PROP_I2C_WRITE              = 1,
    CX_GOSHAWK2_DIAG_PROP_I2C_READ               = 2,
    CX_GOSHAWK2_DIAG_PROP_I2C_WRITE_THEN_READ    = 3    
} CX_GOSHAWK2_DIAGNOSTIC_PROPERTIES;
///


////////////////////////////////////////////////////////////////
//OnInit
//Create tuner and CaptureFilterm ,and connect them;
void OnInit()
{
		// TODO: Add extra initialization here
	m_pTunerDevice = NULL;
	tuningspace = NULL;
	builder = NULL;
	provider = NULL;
	CaptureFilter = NULL;
	TSDump = NULL;
	control = NULL;
	demux = NULL;
	tif = NULL;
	infinite = NULL;

	CoCreateInstance(CLSID_FilterGraph,NULL,CLSCTX_INPROC_SERVER,IID_IGraphBuilder,(void**)&builder);
	builder->QueryInterface(IID_IMediaControl,(void**)&control);
	// Create filters
	provider=CreateDVBSNetworkProvider();

	if(provider)
	{
		builder->AddFilter(provider, L"Network DVBS Provider");
	}
	else
	{
		MessageBox("CreateDVBSNetworkProvider Failed","error",MB_OK);
		return FALSE;
	}

	if(!TunerFilter)	//TunerFilter has been created in CheckDeviceReady() !!!
	{
		TunerFilter=CreateTunerDevice();
	}

	if(TunerFilter)
	{
		builder->AddFilter(TunerFilter,TunerName);
	}
	else
	{
		Sleep(3000);

		TunerFilter=CreateTunerDevice();//ٴж

		if(TunerFilter)
		{
			builder->AddFilter(TunerFilter,TunerName);
		}
		else
		{
			MessageBox("CreateTunerDevice Failed","error",MB_OK);
			return FALSE;
		}
	}

	//CaptureDevice
	CaptureFilter=CreateCaptureDevice();
	if(CaptureFilter)
	{
		builder->AddFilter(CaptureFilter,CaptuerName);
	}
	else
	{
		Sleep(3000);

		CaptureFilter=CreateCaptureDevice();
		if(CaptureFilter)
		{
			builder->AddFilter(CaptureFilter,CaptuerName);
		}
		else
		{
			MessageBox("CreateCaptureDevice Failed","error",MB_OK);
			return FALSE;
		}
	}
	


	demux=CreateMPEG2Demultiplexer();
	if(demux)
	{
		builder->AddFilter(demux,L"MPEG2 Demultiplexer");
	}
	else
	{
		MessageBox("CreateMPEG2Demultiplexer Failed","error",MB_OK);
		return FALSE;
	}

	infinite=CreateInfinitePinTee();
	if(infinite)
	{
		builder->AddFilter(infinite,L"Infinite pin tee splitter");
	}
	else
	{
		MessageBox("CreateInfinitePinTee Failed","error",MB_OK);
		return FALSE;
	}

	tif=CreateTransportInformationFilter();
	if(tif)
	{
		builder->AddFilter(tif, L"transport information filter");
	}
	else
	{
		MessageBox("CreateInfinitePinTee Failed","error",MB_OK);
		return FALSE;
	}
	m_pFilterDest= new CDestFilter(0, &m_Lock, &hr);
	m_pFilterDest->AddRef();
	hr=builder->AddFilter(m_pFilterDest,L"Dest Filter");

	m_pTunerDevice = TunerFilter;
	if(DeviceType==2)
		VideoCaptureFilter = CreateCaptureIRDevice();
	if(DeviceType==1)
		VideoCaptureFilter = Create8910CaptureIRDevice();
	if(DeviceType==5)
		VideoCaptureFilter = CreatePCICaptureIRDevice();
		
		
	//Connected the created tuner and capture
	ConnectPins(builder,provider,TunerFilter);
	ConnectPins(builder,TunerFilter,CaptureFilter);
	ConnectPins(builder, CaptureFilter, infinite);
	ConnectPins(builder,infinite, demux);	
	ConnectPins(builder,infinite, m_pFilterDest);
	ConnectPins(builder,demux, tif);


	//Get the interface
	//USB Devive init ALL use it 
	if((DeviceType==3)||(DeviceType==4)||like 5921 QBOXS2 and son)
	{
		m_pKsCtrl = NULL;
		if(!ll_init && m_pTunerDevice != NULL)
		{
			hr = m_pTunerDevice->QueryInterface(__uuidof( m_pKsCtrl ),
				reinterpret_cast< void** >( &m_pKsCtrl ) );
			if (FAILED(hr))    
			{
				ll_init = 1;
				MessageBox("m_pTunerDevice QueryInterface Failed","error",MB_OK);
				m_pKsCtrl = NULL;
				return FALSE;			
			}
		}
	}
	
	//PCI or PCI-E initDeviceType = 6921,8921,6920,8920,
	if((DeviceType==1)||(DeviceType==2)||(DeviceType==5))
	{
		m_pKsCtrl = NULL;
		m_pTunerPin=NULL;
		m_pTunerPin = FindPinOnFilter(m_pTunerDevice, "Input0");
		if(!ll_init && m_pTunerPin != NULL)
		{

			hr = m_pTunerPin->QueryInterface(IID_IKsPropertySet,
				reinterpret_cast<void**>(&m_pKsCtrl));
			if (FAILED(hr))    
			{
				ll_init = 1;
				MessageBox("m_pTunerDevice QueryInterface Failed","error",MB_OK);
				m_pKsCtrl = NULL;
				return FALSE;			
			}
		}

	}
}
//End init
////////////////////////////////////////////////////////////

/////////////////////////////
//Connect pin
void ConnectPins(IGraphBuilder *builder,IBaseFilter *out_from,IBaseFilter *in_to,WCHAR *from_name,WCHAR *to_name)
{
	CComPtr<IEnumPins> pins;
	CComPtr<IPin> out_pin;
	CComPtr<IPin> in_pin;
	CComPtr<IPin> temp;
	PIN_INFO info;
	HRESULT hResult;
	BOOL bConnected;

	if(builder == NULL)
	{
		MessageBox(NULL, "ConnectPins builder == NULL","error",MB_OK);
		return ;
	}
	if(out_from == NULL)
	{
		MessageBox(NULL, "ConnectPins out_from == NULL","error",MB_OK);
		return ;
	}
	if(in_to == NULL)
	{
		MessageBox(NULL, "ConnectPins in_to == NULL","error",MB_OK);
		return ;
	}

	// Find output pin of out_from
	out_from->EnumPins(&pins);
	pins->Reset();
	while(pins->Next(1,&out_pin,NULL)==S_OK) 
	{
		out_pin->ConnectedTo(&temp);
		bConnected=temp.p!=NULL;
		temp.Release();
		if(!bConnected) 
		{
			out_pin->QueryPinInfo(&info);
			if((info.dir==PINDIR_OUTPUT)&&((from_name==NULL)?TRUE:(wcscmp(info.achName,from_name)==0))) break;
		}
		out_pin.Release();
	}
	pins.Release();
	if(!out_pin) 
	{
		AfxMessageBox("CBDAGraph::ConnectPins() - No output pin found on filter\r\n");
		return;
	}
	// Find input pin of in_to
	in_to->EnumPins(&pins);
	pins->Reset();
	while(pins->Next(1,&in_pin,NULL)==S_OK) 
	{
		in_pin->ConnectedTo(&temp);
		bConnected=temp.p!=NULL;
		temp.Release();
		if(!bConnected) 
		{
			in_pin->QueryPinInfo(&info);
			if((info.dir==PINDIR_INPUT)&&((to_name==NULL)?TRUE:(wcscmp(info.achName,to_name)==0))) break;
		}
		in_pin.Release();
	}
	pins.Release();
	if(!in_pin) 
	{
		AfxMessageBox("CBDAGraph::ConnectPins() - No input pin found on filter\r\n");
		return;
	}
	// Join them together
	if((hResult=builder->Connect(out_pin,in_pin))!=S_OK) 
	{
		AfxMessageBox("CBDAGraph::ConnectPins() - Could not connect pins together. Error was: ");
	}
}
//end connect pin
//////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////
//lock transponder
void OnLockTransponder() 
{

	HRESULT hr;
	DWORD type_support = 0;

 	unsigned long BytesRead=0;
	unsigned long ll_freq=0;
	unsigned long ll_lnblowfreq=0;
	unsigned long ll_lnbhighfreq=0;
	unsigned long ll_symbolrate=0;
	unsigned long ll_lnbfreq=0;
	unsigned long ll_lnbswitchfreq =0;
	
	int dvbtype = 0;
	CString ls_freq;
	CString ls_symbol;
	CString ls_lnblow;
	CString ls_lnbhigh;
	CString ls_lnbswitch;

	if(m_bIPCheck)
	{
		if(control != NULL )
		{
			control->Stop();
		}
	}


	m_CmdData.DiSEqC_Port=m_curdiseqc;

	m_CmdData.LNB_POWER=m_curlnbpower;

	m_CmdData.motor[0]=0;
	m_CmdData.motor[1]=0;
	m_CmdData.motor[2]=0;
	m_CmdData.motor[3]=0;
	m_CmdData.motor[4]=0;


	if(m_pKsCtrl == NULL)
	{
		MessageBox("OnOK m_pKsCtrl Failed","error",MB_OK);
		AddLog(L" << OnOK m_pKsCtrl Failed !");
		return ;
	}


	m_freq.GetWindowText(ls_freq);
	m_symbol.GetWindowText(ls_symbol);
	m_lnblow.GetWindowText(ls_lnblow);
	m_lnbhi.GetWindowText(ls_lnbhigh);
	m_lnbsw.GetWindowText(ls_lnbswitch);
	
	ll_freq=_ttoi(ls_freq);
	ll_symbolrate=_ttoi(ls_symbol);
	ll_lnblowfreq=_ttoi(ls_lnblow);
	ll_lnbhighfreq=_ttoi(ls_lnbhigh);
	ll_lnbswitchfreq=_ttoi(ls_lnbswitch);


	m_CmdData.Polarity=m_curpolarity;

	m_CmdData.ChannelFrequency=ll_freq;
	m_CmdData.ulLNBLOFLowBand=ll_lnblowfreq;
	m_CmdData.ulLNBLOFHighBand=ll_lnbhighfreq;
	m_CmdData.SymbolRate=ll_symbolrate;


	m_CmdData.HZ_22K=HZ_22K_OFF;


//USB
	if(DeviceType==TBS_QBOX)
	{
		if(m_pKsCtrl)
		{
			hr = m_pKsCtrl->Set(KSPROPERTYSET_QBOXControl,
				KSPROPERTY_CTRL_TUNER,
				NULL,
				0,
				&m_CmdData,
				sizeof( QBOXDVBSCMD ));
			CComPtr <IDVBTuneRequest>  pTuneRequest;
			if(FAILED (CreateDVBTuneRequest(&pTuneRequest,&m_CmdData)))
				AfxMessageBox("CreateDVBTuneRequest is invalid!");
			WaitForSingleObject( hIOMutex, INFINITE );

			CComQIPtr<ITuner> pTuner(provider);
			hr=pTuner->put_TuneRequest(pTuneRequest);
			ReleaseMutex(hIOMutex);
		}
		else
		{
			hr=E_FAIL;
		}

	}
	
	
	if((DeviceType==TBS_S6980_A)||(DeviceType==TBS_S6980_B)||(DeviceType==TBS_S6920)
		||(DeviceType==TBS_S6921)||(DeviceType==TBS_S8920)||(DeviceType==TBS_S8910)
		||(DeviceType==TBS_S6925)||(DeviceType==TBS_S8921)||(DeviceType==TBS_S6981_A)||(DeviceType==TBS_S6981_B)
		|| (DeviceType==TBS_QUAD_A)|| (DeviceType==TBS_QUAD_B)|| (DeviceType==TBS_QUAD_C)|| (DeviceType==TBS_QUAD_D))
	{


		if(m_curdiseqc>0)
		{
			int nCom1 = 0xe0;
			int nCom2 = 0x10;
			int nCom3 = 0x38;
			int nCom4 = 0xf0;
			BYTE buf[8];


			// high low band; low band bit0 = 0;
			if(ll_lnbfreq == 10600)
			{
				nCom4 += 0x01;
			}
			// polarzation; if (V or L) bit1 = 0;
			if(m_CmdData.Polarity > 0)
			{
				nCom4 += 0x02;
			}

			//satellite position and option; bit2 and bit3;	
			switch(m_curdiseqc)
			{
			case 1:
				nCom4 &= 0xf3;			//0xf0,0xf1,0xf2,0xf3;
				break;
			case 2:
				nCom4 += 0x04;			//0xf4,0xf5,0xf6,0xf7;
				break;
			case 3:
				nCom4 += 0x08;			//0xf8,0xf9,0xfa,0xfb;
				break;
			case 4:
				nCom4 += 0x0c;			//0xfc,0xfd,0xfe,0xff;
				break;
			default:
				nCom4 = 0xf0;
			}
			buf[0] = (BYTE)nCom1;
			buf[1] = (BYTE)nCom2;
			buf[2] = (BYTE)nCom3;
			buf[3] = (BYTE)nCom4;
			SendDiseqCommand(buf,4);
		}


		CComPtr <IDVBTuneRequest>  pTuneRequest;
		if(FAILED (CreateDVBTuneRequest(&pTuneRequest,&m_CmdData)))
		{
			AfxMessageBox("CreateDVBTuneRequest is invalid!");
			AddLog(L" << CreateDVBTuneRequest is invalid!");

		}
		WaitForSingleObject( hIOMutex, INFINITE );


		CComQIPtr<ITuner> pTuner(provider);
		hr=pTuner->put_TuneRequest(pTuneRequest);
		ReleaseMutex(hIOMutex);


		if(FAILED(hr))
		{
			MessageBox("KSPROPERTY_CTRL_TUNER set channel_change false","error",MB_OK);
			AddLog(L" << KSPROPERTY_CTRL_TUNER set channel_change false!");
		}
		else
		{
			//m_bLock = TRUE;
		}
	}
	
  control->Run();

}
//end lock transponder
///////////////////////////////////////////////////////


//////////////////////////////////////////
//Send Diseq
bool SendDiseqCommand(BYTE *cmd,int cmdlen)
{
	bool	bRet = FALSE;
  HRESULT hr=S_OK;
	ULONG bytesReturned = 0;
	DWORD TypeSupport=0;

		if(nDeviceType == TBS5980 || nDeviceType == TBSQBOX3|| nDeviceType == TBS5922)
	{
		if (m_pKsCtrl)
		{		
			QBOXDVBSCMD DiSEqCRequest;
			ZeroMemory(&DiSEqCRequest, sizeof(DiSEqCRequest));

			CopyMemory(DiSEqCRequest.motor, cmd, 4);

			hr = m_pKsCtrl->Set(KSPROPERTYSET_QBOXControl,
				KSPROPERTY_CTRL_MOTOR,
				&DiSEqCRequest,sizeof( QBOXDVBSCMD ),
				&DiSEqCRequest,sizeof( QBOXDVBSCMD ));

			if (hr == S_OK)
			{
				bRet = TRUE;
			}

		}
	}
	
	if(nDeviceType == TBS6925|| nDeviceType == TBS6922|| nDeviceType == TBS6984A
		|| nDeviceType == TBS6984B|| nDeviceType == TBS6984C|| nDeviceType == TBS6984D)
	{

		if (m_pKsCtrl)
		{		
			TBSDISEQC_MESSAGE_PARAMS DiSEqCRequest;
			ZeroMemory(&DiSEqCRequest, sizeof(DiSEqCRequest));

			DiSEqCRequest.uc_diseqc_send_message_length = cmdlen;
			CopyMemory(DiSEqCRequest.uc_diseqc_send_message, cmd, cmdlen);

			if (m_pKsCtrl->Set(KSPROPSETID_BdaTunerExtensionProperties, 
				KSPROPERTY_BDA_DISEQC_MESSAGE, 
				&DiSEqCRequest,sizeof(TBSDISEQC_MESSAGE_PARAMS),
				&DiSEqCRequest, sizeof(TBSDISEQC_MESSAGE_PARAMS)
				)  == S_OK)
			{
				bRet = TRUE;
			}


		}

	}//end if(nDeviceType = TBS6925)


	if (nDeviceType == TBS6921 || nDeviceType == TBS8921|| nDeviceType == TBS8922
		|| nDeviceType == TBS8920|| nDeviceType == TBS6920|| nDeviceType == TBS6981A
		|| nDeviceType == TBS6981B|| nDeviceType == TBS6980A|| nDeviceType == TBS6980B)
	{
		if (m_pKsCtrl)
		{

			hr = m_pKsCtrl->QuerySupported(KSPROPSETID_BdaTunerExtensionProperties,
				KSPROPERTY_BDA_DISEQC_MESSAGE, 
				&TypeSupport);

			if (FAILED(hr))
			{
				// DiSEqC Interface Not Supported
			} 
			else
			{
				// DiSEqC Interface Found	

				DISEQC_MESSAGE_PARAMS DiSEqCRequest;
				ZeroMemory(&DiSEqCRequest, sizeof(DiSEqCRequest));

				if (cmdlen > 8)
					cmdlen = 8;
				DiSEqCRequest.tbscmd_mode = TBSDVBSCMD_DISEQC;
				DiSEqCRequest.uc_diseqc_send_message_length = cmdlen;
				CopyMemory(DiSEqCRequest.uc_diseqc_send_message, cmd, cmdlen);
				if (m_KsTunerPropSet->Get(KSPROPSETID_BdaTunerExtensionProperties, 
					KSPROPERTY_BDA_DISEQC_MESSAGE, 
					&DiSEqCRequest,sizeof(DISEQC_MESSAGE_PARAMS),
					&DiSEqCRequest, sizeof(DISEQC_MESSAGE_PARAMS),
					&bytesReturned)  == S_OK)
					bRet = TRUE;
			}

		}
	}

	return bRet;
}
//End SendDiseq
///////////////////////////////////////////////////////////

////////////////////
//QBox USE SendDiseq
HRESULT  turbosight_qbox_send_diseqc(unsigned char *cmd, int len)
{
	DWORD TypeSupport=0;
	HRESULT hr = ppropsetTunerFilter_qbox->QuerySupported(KSPROPERTYSET_QBOXControl, 
                        				KSPROPERTY_CTRL_MOTOR, 
										&TypeSupport);
	
	if FAILED(hr)
	//if (FAILED(hr) || !(TypeSupport & KSPROPERTY_SUPPORT_SET))
	{
			AddLog(L"ERROR: Turbosight QBox KSPROPERTY_CTRL_MOTOR not supported!");			
			return E_FAIL;
	}


	QBOXDVBSCMD QBoxCmd;
	ZeroMemory(&QBoxCmd, sizeof(QBoxCmd));	
	CopyMemory(QBoxCmd.motor, cmd, len);	

	WaitForSingleObject( hIOMutex, INFINITE );

	hr = ppropsetTunerFilter_qbox->Set(KSPROPERTYSET_QBOXControl, 
                        				KSPROPERTY_CTRL_MOTOR, 
					      			    NULL,
									    0,
										&QBoxCmd,
										sizeof( QBOXDVBSCMD ));

	ReleaseMutex(hIOMutex);

	Sleep(200);

	if FAILED(hr)	
	{
			AddLog(L"FAILED: Turbosight QBox KSPROPERTY_CTRL_MOTOR failed!");			
			return hr;
	}

	return hr;

}

//end QBox



char* CreateDVBTuneRequest(IDVBTuneRequest**   pTuneRequest2,QBOXDVBSCMD *p_CmdData)
{
    HRESULT hr = S_OK;


    if (tuningspace==NULL)
			return "CreateTuneRequest: Can't create tune request.\n";
		CComPtr <ITuneRequest> pNewTuneRequest;

    //  Create an instance of the DVB tuning space

	///////////////  - satelite -
		CComQIPtr <IDVBSTuningSpace> pDVBSTuningSpace (tuningspace);
		
		if (!pDVBSTuningSpace)
			return   TEXT("Cannot QI for an IDVBSTuningSpace\n");
        
		if(p_CmdData){
				hr=pDVBSTuningSpace->put__NetworkType(CLSID_DVBSNetworkProvider);
				hr=pDVBSTuningSpace->put_LNBSwitch(GetLNBValue(p_CmdData->ChannelFrequency,p_CmdData->ulLNBLOFHighBand,p_CmdData->ulLNBLOFLowBand)*1000);				
				hr=pDVBSTuningSpace->put_HighOscillator(p_CmdData->ulLNBLOFHighBand*1000);
				hr=pDVBSTuningSpace->put_LowOscillator(p_CmdData->ulLNBLOFLowBand*1000);
		};
		

		//  Create an empty tune request.
		hr = pDVBSTuningSpace->CreateTuneRequest(&pNewTuneRequest);


    if (FAILED (hr))
			return "CreateTuneRequest: Can't create tune request.\n";
        
    //query for an IDVBChannelTuneRequest interface pointer
    CComQIPtr <IDVBTuneRequest> pDVBTuneRequest (pNewTuneRequest);
    if (!pDVBTuneRequest)
      return TEXT("CreateDVBTuneRequest: Can't QI for IChannelTuneRequest.\n");
          
  /*
	if(p_CmdData){
		hr=pDVBTuneRequest->put_SID(ch->m_SID);
		hr=pDVBTuneRequest->put_TSID(ch->m_TID);
		hr=pDVBTuneRequest->put_ONID(ch->m_NIT);
	};
	  */
	///////////////  - satelite -
		CComPtr <IDVBSLocator>		pDVBSLocator;	
		
		hr = pDVBSLocator.CoCreateInstance (CLSID_DVBSLocator);
		if (FAILED( hr)) return "Cannot create the DVBS locator failed\n";
        
		if(p_CmdData){
				pDVBSLocator->put_OuterFEC(BDA_FEC_VITERBI);
				pDVBSLocator->put_OuterFECRate(BDA_BCC_RATE_3_4);
//					if(ch->m_IsDVB_S2) pDVBSLocator->put_Modulation(BDA_MOD_8VSB);
		
				hr=pDVBSLocator->put_CarrierFrequency(p_CmdData->ChannelFrequency*1000);
				hr=pDVBSLocator->put_SignalPolarisation(p_CmdData->Polarity?BDA_POLARISATION_LINEAR_V:BDA_POLARISATION_LINEAR_H);
				hr=pDVBSLocator->put_SymbolRate(p_CmdData->SymbolRate);
		};	
		
		hr = pDVBTuneRequest->put_Locator (pDVBSLocator);
	


    if (FAILED (hr))  return TEXT("Cannot put the locator\n");
      

    hr = pNewTuneRequest.QueryInterface (pTuneRequest2);

    return FAILED (hr) ? "Error on create pTuneRequest2":0;
}



/////////////////////////////////////////////////////////////////
//6981 6921 6980 6920 IR init

const GUID KSPROPSETID_VIDCAP_CUSTOM_IRCAPTURE = 
{0xB51C4994,0x0054,0x4749,{0x82,0x43,0x02,0x9A,0x66,0x86,0x36,0x36}};

typedef enum
{
    KSPROPERTY_IRCAPTURE_KEYSTROKES         = 0,
    KSPROPERTY_IRCAPTURE_COMMAND            = 1

}KSPROPERTY_IRCAPTURE_PROPS;


HRESULT turbosight_after_graph_start()
{
	// must be executed after graph started
	// init RC	
	HRESULT hr;
	DWORD TypeSupport=0;
	KSPROPERTY_IRCAPTURE_KEYSTROKES_S  kStore={1,1};
	KSPROPERTY ks;
	ks.Id=KSPROPERTY_IRCAPTURE_KEYSTROKES;
	KSPROPERTY_IRCAPTURE_COMMAND_S tem;	
	AddLog(L"turbosight_after_graph_start()");

	if (ppropsetIRCaptureFilter) 
	{
		 hr = ppropsetIRCaptureFilter->QuerySupported(KSPROPSETID_VIDCAP_CUSTOM_IRCAPTURE,KSPROPERTY_IRCAPTURE_COMMAND,&TypeSupport);
		 if (hr==S_OK) 
		 {
			 if (TypeSupport & KSPROPERTY_SUPPORT_SET) 	
			 {
				 AddLog(L"KSPROPERTY_IRCAPTURE_COMMAND is supported");

				 tem.CommandCode = IRCAPTURE_COMMAND_START;
				 hr=ppropsetIRCaptureFilter->Set(KSPROPSETID_VIDCAP_CUSTOM_IRCAPTURE,KSPROPERTY_IRCAPTURE_COMMAND,&tem,sizeof(KSPROPERTY_IRCAPTURE_COMMAND_S),
					 &tem,sizeof(KSPROPERTY_IRCAPTURE_COMMAND_S));
				 if (hr==S_OK)
				 {
					 bQuit=false;
					 DWORD ThreadId;
					 AddLog(L"Starting IR-RC thread...");
					 hThread = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)ThreadProc_IR_8910_and_8920,0,0,&ThreadId);
				 }
			 }
	            
		}

	}

	return S_OK;

}

DWORD WINAPI  ThreadProc_IR_8910_and_8920(LPVOID lpParameter)
{
	HRESULT hr;
	
//	ULONG BytesRead;
	KSPROPERTY_IRCAPTURE_KEYSTROKES_S  kStore={1,1};
	KSPROPERTY ks;
	ks.Id=KSPROPERTY_IRCAPTURE_KEYSTROKES;
	DWORD type_support=0 ;
	ULONG pcbReturned;
	BYTE ir_code;
	int i;

	if (!ppropsetIRCaptureFilter)
		return 0;

	CoInitialize(NULL);
//	char str[256];

	while(!bQuit)
	{
        // is ppropsetIRCaptureFilter right one ?  = m_pIRKsCtrl(IID_IKsPropertySet) on CaptureIRFilter     
	
		
		WaitForSingleObject( hIOMutex, INFINITE );
		
		hr=ppropsetIRCaptureFilter->Get(KSPROPSETID_VIDCAP_CUSTOM_IRCAPTURE,KSPROPERTY_IRCAPTURE_KEYSTROKES,&ks,sizeof(ks),
							        &kStore,sizeof(kStore),&pcbReturned);
		ReleaseMutex( hIOMutex);

		ir_code = (BYTE)kStore.dwCommand;
              //DebugString("ircapture  0x%x  0x%x",kStore.dwAddress,kStore.dwCommand);
		if((kStore.dwCommand!=0x0)&&(hr==S_OK))
		{

			if (ir_code > 0x30) 
			{
				for(i=0;i<32;i++)
				{	
					if(RemoteKeysBig[i].code == ir_code)
						SendDDRemoteMsg(RemoteKeysBig[i].dd_rmt_code);					
				}	
			} 
			else
			{

				for(i=0;i<18;i++) 
				{	
					if(RemoteKeysSmall[i].code == ir_code)
						SendDDRemoteMsg(RemoteKeysSmall[i].dd_rmt_code);					
				}	
			}


		}
		else
		{
			Sleep(100);
		}
	}

	CoUninitialize();

	return 0; 
}
//IR ini end
///////////////////////////////////////////////////////